IF EXISTS (SELECT * FROM SYS.OBJECTS WHERE NAME = 'UFD_CG_RETORNA_SALDO_RECEB_FORN')
	DROP FUNCTION [dbo].[UFD_CG_RETORNA_SALDO_RECEB_FORN]
GO
GO
CREATE FUNCTION [dbo].[UFD_CG_RETORNA_SALDO_RECEB_FORN] (@CD_EMP		INT, 
														@CD_VERBA		INT,
														@CD_RECEB		INT=0,	
														@CD_FORN		INT,
														@DATA			DATETIME)	

RETURNS @RS_RETORNO TABLE (SLD_RECB MONEY)

AS
BEGIN

	INSERT INTO @RS_RETORNO
	SELECT
		SUM(R.VLR_RECB) AS SLD_RECB
	FROM 

		CG_FND_VERBA V
		LEFT JOIN CG_FND_VERBA_RECB R ON
		V.CD_EMP = R.CD_EMP AND
		V.CD_FND_VERBA = R.CD_FND_VERBA
	WHERE
		V.CD_EMP=@CD_EMP
		AND V.CD_FND_VERBA= @CD_VERBA
		AND V.CD_FORN = @CD_FORN
		AND R.DT_RECEB <= @DATA
		
		AND (CASE WHEN @CD_RECEB = 0 THEN
					0 ELSE R.CD_FND_VERBA_RECB END) <= @CD_RECEB
		AND R.STATUS = 0

RETURN
END
GO


